/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Locale;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;

public class JarBlockTile
extends ItemDisplayTile
implements IMobContainerProvider,
ISoftFluidTankProvider {
    private final int capacity = CommonConfigs.Functional.JAR_CAPACITY.get();
    public final MobContainer mobContainer;
    public final SoftFluidTank fluidHolder = SoftFluidTank.create((int)this.capacity);

    public JarBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.JAR_TILE.get(), pos, state);
        AbstractMobContainerItem item = (AbstractMobContainerItem)ModRegistry.JAR_ITEM.get();
        this.mobContainer = new MobContainer(item.getMobContainerWidth(), item.getMobContainerHeight(), true);
    }

    public void updateTileOnInventoryChanged() {
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.method_11010().method_11654((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public boolean handleInteraction(class_1657 player, class_1268 hand, class_1937 level, class_2338 pos) {
        class_1799 handStack = player.method_5998(hand);
        class_1799 displayedStack = this.getDisplayedItem();
        if (this.canInteractWithSoftFluidTank() && this.fluidHolder.interactWithPlayer(player, hand, level, pos)) {
            return true;
        }
        if (this.mobContainer.isEmpty() && this.method_5437(0, handStack)) {
            this.handleAddItem(handStack, player, hand);
            return true;
        }
        if (this.method_5442() && this.fluidHolder.isEmpty() && this.mobContainer.interactWithBucket(handStack, level, player.method_24515(), player, hand)) {
            return true;
        }
        if (!player.method_5715() && CommonConfigs.Functional.JAR_EAT.get().booleanValue()) {
            if (this.fluidHolder.tryDrinkUpFluid(player, level)) {
                return true;
            }
            if (displayedStack.method_19267() && player.method_7332(false) && !player.method_7337()) {
                player.method_18866(level, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public class_1799 extractItem() {
        class_1799 myStack = this.getDisplayedItem();
        if (myStack.method_7947() > 0) {
            return myStack.method_7971(1);
        }
        return class_1799.field_8037;
    }

    public boolean handleExtractItem(class_1657 player, class_1268 hand) {
        if (this.getDisplayedItem().method_7909() instanceof class_1785) {
            if (player.method_5998(hand).method_7909() != class_1802.field_8550) {
                return false;
            }
            player.field_6002.method_8396(null, player.method_24515(), class_3417.field_14568, class_3419.field_15245, 1.0f, 1.0f);
        } else if (!player.method_5998(hand).method_7960()) {
            return false;
        }
        class_1799 extracted = this.extractItem();
        if (!extracted.method_7960()) {
            Utils.swapItem((class_1657)player, (class_1268)hand, (class_1799)extracted);
            return true;
        }
        return false;
    }

    public void handleAddItem(class_1799 stack, @Nullable class_1657 player, class_1268 handIn) {
        class_1799 handStack = stack.method_7972();
        handStack.method_7939(1);
        class_1792 item = handStack.method_7909();
        this.addItem(handStack);
        if (player != null) {
            class_1799 returnStack = class_1799.field_8037;
            player.field_6002.method_8396(player, this.field_11867, ModSounds.JAR_COOKIE.get(), class_3419.field_15245, 1.0f, 0.9f + player.field_6002.field_9229.method_43057() * 0.1f);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            if (!player.method_7337()) {
                Utils.swapItem((class_1657)player, (class_1268)handIn, (class_1799)returnStack);
            }
        }
    }

    public void addItem(class_1799 itemstack) {
        if (this.method_5442()) {
            class_2371 stacks = class_2371.method_10213((int)1, (Object)itemstack);
            this.method_11281(stacks);
        } else {
            this.getDisplayedItem().method_7933(Math.min(1, this.method_5444() - this.getDisplayedItem().method_7947()));
        }
    }

    public void resetHolders() {
        this.fluidHolder.clear();
        this.mobContainer.clear();
        this.setDisplayedItem(class_1799.field_8037);
    }

    public boolean isPonyJar() {
        if (this.method_16914()) {
            class_2561 c = this.method_5797();
            return c != null && c.getString().toLowerCase(Locale.ROOT).contains("cum");
        }
        return false;
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (CommonConfigs.Functional.JAR_COOKIES.get().booleanValue() && this.fluidHolder.isEmpty() && this.mobContainer.isEmpty()) {
            class_1792 i = stack.method_7909();
            if (!this.isFull() && JarBlockTile.isCookie(i)) {
                return this.method_5442() || i == this.getDisplayedItem().method_7909();
            }
        }
        return false;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        try {
            this.fluidHolder.load(compound);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("Failed to load fluid container at {}:", (Object)this.method_11016(), (Object)e);
        }
        this.mobContainer.load(compound);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        try {
            this.fluidHolder.save(tag);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("Failed to save fluid container at {}:", (Object)this.method_11016(), (Object)e);
        }
        this.mobContainer.save(tag);
    }

    public boolean hasContent() {
        return !this.method_5442() || !this.mobContainer.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.getDisplayedItem().method_7947() >= this.method_5444();
    }

    public int method_5444() {
        return this.capacity;
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.jar");
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        if (!CommonConfigs.Functional.JAR_COOKIES.get().booleanValue()) {
            return false;
        }
        return JarBlockTile.isCookie(stack.method_7909()) && (this.method_5442() || stack.method_7909() == this.getDisplayedItem().method_7909());
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    @Override
    public MobContainer getMobContainer() {
        return this.mobContainer;
    }

    @Override
    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)ClockBlock.FACING);
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, JarBlockTile tile) {
        tile.mobContainer.tick(pLevel, pPos);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }

    public boolean canInteractWithSoftFluidTank() {
        return CommonConfigs.Functional.JAR_LIQUIDS.get() != false && this.method_5442() && (this.mobContainer.isEmpty() || this.isPonyJar());
    }

    private static boolean isCookie(class_1792 i) {
        return i.method_40131().method_40220(ModTags.COOKIES);
    }
}

